<?php
/**
* Webmasters options.
*
* @package Minimal Lite
*/


// Webmaster Panel.
$wp_customize->add_panel( 'minimal_lite_webmaster_panel',
	array(
		'title'      => esc_html__( 'Webmasters Tools', 'minimal-lite' ),
		'priority'   => 200,
		'capability' => 'edit_theme_options',
	)
);

$wp_customize->add_section( 'tmt_webmasters_tools', array(
        'title'    	=> __( 'Addtional Scripts', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_webmaster_panel',
        
) );

$wp_customize->add_setting( 'tmt_header_script', array(
        'type' => 'option',
        'transport'=>'postMessage',
) );
$wp_customize->add_control( new WP_Customize_Code_Editor_Control( $wp_customize, 'header_script', array(
        'label'     => __( 'Before Header Script', 'minimal-lite' ),
        'code_type' => 'javascript',
        'settings'  => 'tmt_header_script',
        'section'   => 'tmt_webmasters_tools',
        
) ) );


$wp_customize->add_setting( 'tmt_footer_script', array(
        'type' => 'option',
        'transport'=>'postMessage',

) );
$wp_customize->add_control( new WP_Customize_Code_Editor_Control( $wp_customize, 'footer_script', array(
        'label'     => __( 'Aftere Footer Script', 'minimal-lite' ),
        'code_type' => 'javascript',
        'settings'  => 'tmt_footer_script',
        'section'   => 'tmt_webmasters_tools',
        
) ) );

$wp_customize->add_section( 'tmt_site_verification', array(
        'title'    	=> __( 'SIte Verification', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_webmaster_panel',
        
) );

$wp_customize->add_setting( 'tmt_verification_code_google',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	'transport'=>'postMessage',
	)
);
$wp_customize->add_control( 'tmt_verification_code_google',
	array(
	'label'    => esc_html__( 'Google Webmaster Tools', 'minimal-lite' ),
	'section'  => 'tmt_site_verification',
	'type'     => 'text',
	)
);

$wp_customize->add_setting( 'tmt_verification_code_bing',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	'transport'=>'postMessage',
	)
);
$wp_customize->add_control( 'tmt_verification_code_bing',
	array(
	'label'    => esc_html__( 'Bing Webmaster Tools', 'minimal-lite' ),
	'section'  => 'tmt_site_verification',
	'type'     => 'text',
	)
);

$wp_customize->add_setting( 'tmt_verification_code_pinterest',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	'transport'=>'postMessage',
	)
);
$wp_customize->add_control( 'tmt_verification_code_pinterest',
	array(
	'label'    => esc_html__( 'Pinterest Site Verification', 'minimal-lite' ),
	'section'  => 'tmt_site_verification',
	'type'     => 'text',
	)
);

$wp_customize->add_setting( 'tmt_verification_code_alexa',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	'transport'=>'postMessage',
	)
);
$wp_customize->add_control( 'tmt_verification_code_alexa',
	array(
	'label'    => esc_html__( 'Alexa Verification ID', 'minimal-lite' ),
	'section'  => 'tmt_site_verification',
	'type'     => 'text',
	)
);

$wp_customize->add_setting( 'tmt_verification_code_yandex',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	'transport'=>'postMessage',
	)
);
$wp_customize->add_control( 'tmt_verification_code_yandex',
	array(
	'label'    => esc_html__( 'Yandex Webmaster Tools', 'minimal-lite' ),
	'section'  => 'tmt_site_verification',
	'type'     => 'text',
	)
);