<?php
/**
* Open Graph options.
*
* @package Minimal Lite
*/

$default = minimal_lite_get_default_customizer_values();
// Webmaster Panel.
$wp_customize->add_panel( 'minimal_lite_og_panel',
	array(
		'title'      => esc_html__( 'Open Graph', 'minimal-lite' ),
		'priority'   => 200,
		'capability' => 'edit_theme_options',
	)
);

$wp_customize->add_section( 'tmt_open_graph_ed_sec', array(
        'title'    	=> __( 'Open Graph Enable Disable', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_og_panel',
        
) );

// Enable Disable Open Graph.
$wp_customize->add_setting('tmt_ed_open_graph',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'minimal_lite_sanitize_checkbox',
    )
);
$wp_customize->add_control('tmt_ed_open_graph',
    array(
        'label' => esc_html__('Enable Open Graph', 'minimal-lite'),
        'description' => esc_html__('Add meta on head for Open Graph.', 'minimal-lite'),
        'section' => 'tmt_open_graph_ed_sec',
        'type' => 'checkbox',
        'priority' => 1,
    )
);

$wp_customize->add_section( 'tmt_open_graph_home_sec', array(
        'title'    	=> __( 'Homepage Setting', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_og_panel',
        
) );


// Open Graph Title.
$wp_customize->add_setting( 'tmt_open_graph_title',
	array(
	'default'           => $default['tmt_open_graph_title'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_open_graph_title',
	array(
	'label'    => esc_html__( 'Title', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_home_sec',
	'type'     => 'text',
	)
);

// Open Graph Description.
$wp_customize->add_setting( 'tmt_open_graph_desc',
	array(
	'default'           => $default['tmt_open_graph_desc'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_open_graph_desc',
	array(
	'label'    => esc_html__( 'Description', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_home_sec',
	'type'     => 'text',
	)
);

// Open Graph Description.
$wp_customize->add_setting( 'tmt_open_graph_site_name',
	array(
	'default'           => $default['tmt_open_graph_title'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_open_graph_site_name',
	array(
	'label'    => esc_html__( 'Sitename', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_home_sec',
	'type'     => 'textarea',
	)
);

// Open Graph Description.
$wp_customize->add_setting( 'tmt_open_graph_site_type',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'minimal_lite_sanitize_select',
	)
);
$wp_customize->add_control( 'tmt_open_graph_site_type',
	array(
	'label'    => esc_html__( 'Type', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_home_sec',
	'type'     => 'select',
	'choices'	=> array(
			'' => esc_html__('--select--','minimal-lite'),
			'website' => esc_html__('Website','minimal-lite'),
			'video.episode' => esc_html__('video.episode','minimal-lite'),
			'music.radio_station' => esc_html__('music.radio_station','minimal-lite'),
			'music.song' => esc_html__('music.song','minimal-lite'),
			'music.playlist' => esc_html__('music.playlist','minimal-lite'),
			'video.movie' => esc_html__('video.movie','minimal-lite'),
			'music.album' => esc_html__('music.album','minimal-lite'),
			'video.tv_show' => esc_html__('video.tv_show','minimal-lite'),
			'article' => esc_html__('Article','minimal-lite'),
			'video.other' => esc_html__('video.other','minimal-lite'),
			'profile' => esc_html__('Profile','minimal-lite'),
			'book' => esc_html__('Book','minimal-lite'),

		),
	)
);

// Open Graph URL.
$wp_customize->add_setting( 'tmt_open_graph_url',
	array(
	'default'           => $default['tmt_open_graph_url'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control( 'tmt_open_graph_url',
	array(
	'label'    => esc_html__( 'URL', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_home_sec',
	'type'     => 'text',
	)
);


// Header Advertise Image
$wp_customize->add_setting('tmt_open_graph_home_default_image',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control( new WP_Customize_Image_Control(
    $wp_customize,
    'tmt_open_graph_home_default_image',
    	array(
        	'label'      => esc_html__( 'Image for Home and Default Image.', 'minimal-lite' ),
           	'section'    => 'tmt_open_graph_home_sec',
           	'priority' => 10,
       	)
   	)
);

// Open Graph Description.
$wp_customize->add_setting( 'tmt_open_graph_locole',
	array(
	'default'           => $default['tmt_open_graph_locole'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_open_graph_locole',
	array(
	'label'    => esc_html__( 'Locale', 'minimal-lite' ),
	'description'    => esc_html__( 'eg: en_US', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_home_sec',
	'type'     => 'text',
	)
);


$wp_customize->add_section( 'tmt_open_graph_custom_meta_sec', array(
        'title'    	=> __( 'Custom Meta', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_og_panel',
        
) );

// Open Graph Custom Meta.
$wp_customize->add_setting( 'tmt_open_graph_custom_meta',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'minimal_lite_meta_sanitize',
	)
);
$wp_customize->add_control( 'tmt_open_graph_custom_meta',
	array(
	'label'    => esc_html__( 'Custom Meta', 'minimal-lite' ),
	'description'    => esc_html__( 'For example: <meta name="twitter:card" content="summary" />', 'minimal-lite' ),
	'section'  => 'tmt_open_graph_custom_meta_sec',
	'type'     => 'textarea',
	)
);