<?php
/**
 * Custom Customizer Controls.
 *
 * @package minimal-lite
 */

/**
 * Customize Control for Taxonomy Select.
 *
 * @since 1.0.0
 *
 * @see WP_Customize_Control
 */

/** Customizer Catch Clear Button Custom Control **/

/** Customizer Custom Control **/
if ( class_exists( 'WP_Customize_Control' ) ) {
    
    // Radio Image Custom Control Class.
    class Minimal_Lite_Instagram_Notice extends WP_Customize_Control {

      public $type = 'insta-notice';
    
      public function render_content() {
            
        echo '<div class="tmt-insta-notic">';

        echo '<div class="tmt-notice-wrap">';
        echo '<h2>'.esc_html__('Bye bye: This tool is going away!','minimal-lite').'</h2>';
        echo '<span>'.esc_html__('Instagram is deprecating their API platform and have notified developers that they will remove support in early 2020. That means this option will stop working now, and any website using it in the past might stop working!','minimal-lite').'</span>';
        echo '</div>';

        echo '<div class="tmt-notice-wrap">';

        echo '<a target="_blank" href="'.esc_url('https://www.instagram.com/developer/').'">'.esc_html__('Instagram deprecation notice','minimal-lite').'</a>';

        echo '<h2>'.esc_html__('Alternatives to explore? ','minimal-lite').'</h2>';
        echo '<span>'.esc_html__('If the Instagram feed is important for your website, consider plugins that are built with New Facebook Developer API. We are also working on brand new plugin to introduce this feature.','minimal-lite').'</span>';
        echo '</div>';


        echo '</div>';
            
      }
    }
    
}

// Access Token Generate Link.
class  Minimal_Lite_Instagram_Access_Token extends WP_Customize_Control {

    public $type = 'accesstoken';

    public function render_content() {
       
        $name = '_customize-radio-' . $this->id; ?>
        
        <div class="customize-control-title">

            <span class="tmt-customizer-title"><?php echo esc_html( $this->label ); ?></span>

            <div class="tmt-access-token-generator">
                <p class="tmt-instagram-info">
                    <?php esc_html_e('In order to display your Instagram photos on your own website, you are required to provide an Instagram Access Token. You can do this by clicking the generator button below. After clicking, you\'ll be redirected to  Pixel Union. You\'ll find more details there.','minimal-lite'); ?>
                </p>
                <div class="tmt-instagram-token">
                    <a href="<?php echo esc_url( 'https://instagram.pixelunion.net/' ); ?>" target="_blank" class="button button-primary">
                        <?php esc_html_e('Generate Access Token','minimal-lite'); ?>
                    </a>
                </div>
            </div>
        </div>
        
    <?php }
}
    
// Clear Cache Class.
class Minimal_Lite_Clear_Cache extends WP_Customize_Control {

    public $type = 'clearcache';

    public function render_content() {
       
        $name = '_customize-radio-' . $this->id; ?>
        
        <span class="customize-control-title">
            <span class="tmt-customizer-title"><?php echo esc_html( $this->label ); ?></span>

            <div class="tmt-clear-cache">
                <input id="customizer-cache-clear" class="button button-primary" value="<?php esc_html_e('Clear Cache','minimal-lite'); ?>" type="button"/>
            </div>
        </span>
        
    <?php }
}

class Minimal_Lite_Dropdown_Taxonomies_Control extends WP_Customize_Control {

	/**
	 * Control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'dropdown-taxonomies';

	/**
	 * Taxonomy.
	 *
	 * @access public
	 * @var string
	 */
	public $taxonomy = '';

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id      Control ID.
	 * @param array                $args    Optional. Arguments to override class property defaults.
	 */
	public function __construct( $manager, $id, $args = array() ) {

		$our_taxonomy = 'category';
		if ( isset( $args['taxonomy'] ) ) {
			$taxonomy_exist = taxonomy_exists( esc_attr( $args['taxonomy'] ) );
			if ( true === $taxonomy_exist ) {
				$our_taxonomy = esc_attr( $args['taxonomy'] );
			}
		}
		$args['taxonomy'] = $our_taxonomy;
		$this->taxonomy = esc_attr( $our_taxonomy );

		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render content.
	 *
	 * @since 1.0.0
	 */
	public function render_content() {

		$tax_args = array(
			'hierarchical' => 0,
			'taxonomy'     => $this->taxonomy,
		);
		$all_taxonomies = get_categories( $tax_args );

	?>
    <label>
      <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
       <select <?php $this->link(); ?>>
			<?php
			printf( '<option value="%s" %s>%s</option>', '', selected( $this->value(), '', false ), ' ' );
			?>
			<?php if ( ! empty( $all_taxonomies ) ) :  ?>
            <?php foreach ( $all_taxonomies as $key => $tax ) :  ?>
				<?php
				printf( '<option value="%s" %s>%s</option>', esc_attr( $tax->term_id ), selected( $this->value(), $tax->term_id, false ), esc_html( $tax->name ) );
				?>
            <?php endforeach ?>
			<?php endif ?>
       </select>
    </label>
    <?php
	}
}